#Main script to download all Data from all sites. 
#Paths for Saving and Reading in Files ---------------------------
iPath <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Analysis Scripts"
source(file.path(iPath,"All_USGS_DataDownload.R"))

iPath_Out_Daily <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Output Data Tables/Daily" ##Path for the files to be downloaded. 
iPath_Out_Annual <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Output Data Tables/Annual"
iPath_Out_Meta <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Output Data Tables/Metadata"
iPath_Out_NCDC <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Data Files/NCDC Storm Data Files/Flood_Events_1951_2016"  

Data <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Data Files/USGS_Site Data (HUC Regions)/Sites_USGS_HUC.csv" 

Meta_SiteHUC8 <- "Metadata_SiteHUC8.csv"
Meta_SiteHUC6 <- "Metadata_SiteHUC6.csv"

Cons_Table <- "Consistency_Table.csv"
Return_Period_HUC8 <- "SiteID_Return_Period8.csv"
Return_Period_HUC6 <- "SiteID_Return_Period6.csv"
HUC8_Meta <- "Metadata_HUC8.csv"
HUC6_Meta <- "Metadata_HUC6.csv"
NCDC_Data <- "Flood_Events_1996_2016_Coastal.csv"

# List of All Available Sites ---------------------------------------------

Site_Cd <- Site_Codes(Data)

# Downloading Daily Mean Discharge (All available sites) ------------------

All_Sites_Download_Daily(Site_Cd)
All_Sites_Download_Annual(Site_Cd)

# Creating Metadata file for All Sites Downloaded ------------------------------

Metadata_Site(Site_Cd) #Need to remember that this does not include HUC8 need to join using GIS

# Consistency Table: 1900-2016 (Daily Data) -------------------------------

Cont_Table(Meta_SiteHUC8)

# Creating Metadata file for HUC8's ---------------------------------------

Metadata_HUC8(Meta_SiteHUC8)
Metadata_HUC6(Meta_SiteHUC6)

# Return Period Function --------------------------------------------------
source(file.path(iPath, "All_USGS_ReturnPeriods.R"))

Return_Period(Meta_SiteHUC6)

# Analysis Functions (HUC8) ------------------------------------------------------
source(file.path(iPath, "All_USGS_Analysis.R"))
source(file.path(iPath, "All_USGS_IndividualAnalysis.R"))

Analysis_NoRecalc_AggregatedEvents <- Flood_Data_Analysis(HUC8_Meta,"2000-10-1","2015-9-30", TRUE, 3, 10)

Individual <- Analysis_Individual(08070202, "2016-08-01", "2016-09-01", TRUE, 15, 15)

# Analysis Functions (HUC6) -----------------------------------------------
source(file.path(iPath, "All_USGS_Analysis_HUC6.R"))
source(file.path(iPath, "All_USGS_IndividualAnalysis_HUC6.R"))

Analysis_HUC6_13 <- Flood_Data_Analysis_HUC6(HUC6_Meta,"2000-10-1","2015-9-30", FALSE, 3, 10) 

Individual_HUC6 <- Analysis_Individual_HUC6(010100, "2016-08-01", "2015-9-01", TRUE, 1, 1)

# Analysis Functions (NCDC) -----------------------------------------------
source(file.path(iPath, "NCDC_Analysis.R"))

State <- c("NEW YORK")
County <- c("DELAWARE")

NCDC <- NCDC_Analysis(NCDC_Data, "2000-10-01", "2015-9-30", 3, 10)

# Analysis Plots ----------------------------------------------------------
source(file.path(iPath, "All_USGS_Analysis_Plots.R"))
iPath_Image <- "R:/2017/NonClients/Morrill/Work/R-Scripts/Flood Project Scripts/Figures"
Temporal_Estimates <- "TemporalWindow_Estimates.csv"
NCDC_Estimates <- "NCDC_Estimates.csv"
HUC8_Compare <- "HUC8_FreqCompare.csv"

Analysis_Line(Analysis)
Analysis_Histogram(Analysis)
Analysis_Histogram_Site(Analysis)
Analysis_Histogram_Spacing(Analysis)
Analysis_Duration(Analysis)

Analysis_Severity(Analysis_AllEvents)

Duration_Comparison(Historical)

Analysis_Line_NCDC(NCDC_Estimates)
Analysis_TemporalPlot(Temporal_Estimates)
Analysis_Compare(HUC8_Compare)
